(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8377,        205]*)
(*NotebookOutlinePosition[      9217,        232]*)
(*  CellTagsIndexPosition[      9173,        228]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\( (*\ 
      Gauss\ quadrature\ with\ m = 12\ from\  - \[Pi]\ to\ \(\[Pi] . \)\ \ *) 
      \n (*\ \[Tau]_i = 
        \(\[Pi]\[Xi]_i\ \nNote\ that\ integral = 
          sum\ w_i\ f \((\[Xi]_i)\)\)\ \ *) \n\[Xi]1 = \(-0.9815606342\); \n
    \[Xi]2 = \(-0.9041172564\); \n\[Xi]3 = \(-0.7699026742\); \n
    \[Xi]4 = \(-0.5873179543\); \n\[Xi]5 = \(-0.3678314990\); \n
    \[Xi]6 = \(-0.1252334085\); \n\[Xi]7 = 0.1252334085; \n
    \[Xi]8 = 0.3678314990; \n\[Xi]9 = 0.5873179543; \n\[Xi]10 = 0.7699026742; 
    \n\[Xi]11 = 0.9041172564; \n\[Xi]12 = 0.9815606342; \nw1 = 0.0471753364; 
    \nw2 = 0.1069393260; \nw3 = 0.1600783285; \nw4 = 0.2031674267; \n
    w5 = 0.2334925365; \nw6 = 0.2491470458; \nw7 = 0.2491470458; \n
    w8 = 0.2334925365; \nw9 = 0.2031674267; \nw10 = 0.1600783285; \n
    w11 = 0.1069393260; \nw12 = 0.0471753364; \n
    f[t_, \[Tau]_]\  := \ 1/\((0.68\  - \ 0.32*Cos[t + \[Tau]])\); 
    \n (*\ \ The\ lhs\ of\ Eq\ \((1)\)\ \ *) \n
    \(y1 + \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]\ \[Xi]7, \[Pi]\ \[Xi]12]\ )\) // N\) // 
      Simplify\)\)], "Input"],

Cell[BoxData[
    \(1.1792347730422219`\ y1 + 0.360761935471563344`\ y2 + 
      0.316237136498173532`\ y3 + 0.143806374644843515`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((2)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y2 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]\ \[Xi]8, \[Pi]\ \[Xi]12]\ )\) // N\) // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(0.128927707738326645`\ y1 + 1.30675440650101082`\ y2 + 
      0.374121665584224238`\ y3 + 0.190210764329249322`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((3)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y3 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]\ \[Xi]9, \[Pi]\ \[Xi]12]\ )\) // N\) // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(0.109701803078912929`\ y1 + 0.273275550179975912`\ y2 + 
      1.38906021860081629`\ y3 + 0.227959242485897739`\ y4\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \( (*\ The\ lhs\ of\ Eq\ \((4)\)\ \ *) \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(y4 + 
          \((3/\((10\ )\))\)*\ 
            \((\ y1*w1*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]1] + \ 
                y2*w2*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]2] + \ \ 
                y3*w3*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]3]\  + \ \ 
                y4*w4*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]4] + \ \ 
                y3*w5*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]5] + \ \ 
                y2*w6*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]6] + \ 
                y1*w7*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]7] + \ 
                y2*w8*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]8] + \ 
                y3*w9*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]9] + \ 
                y4*w10*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]10] + \ 
                y3*w11*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]11] + \ 
                y2*w12*f[\[Pi]\ \[Xi]10, \[Pi]\ \[Xi]12]\ )\) // N\) // 
      Simplify\)], "Input"],

Cell[BoxData[
    \(0.109106141262436363`\ y1 + 0.277217059749168459`\ y2 + 
      0.39042969998449255`\ y3 + 1.22324585460080625`\ y4\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Now\ to\ solve\ the\ four\ equations\ *) \n
    NSolve[{1.1792347730422219`\ y1 + 0.360761935471563344`\ y2 + 
            0.316237136498173532`\ y3 + 0.143806374644843515`\ y4 == \ 25, \n
        0.128927707738326645`\ y1 + 1.30675440650101082`\ y2 + 
            0.374121665584224238`\ y3 + 0.190210764329249322`\ y4 == \ 21, \n
        0.109701803078912929`\ y1 + 0.273275550179975912`\ y2 + 
            1.38906021860081629`\ y3 + 0.227959242485897739`\ y4 == \ 13, \n
        0.109106141262436363`\ y1 + 0.277217059749168459`\ y2 + 
            0.39042969998449255`\ y3 + 1.22324585460080625`\ y4 == \ 9}, 
      \ {y1, y2, y3, y4}]\n\)\)], "Input"],

Cell[BoxData[
    \({{y1 \[Rule] 15.6807911340871513`, y2 \[Rule] 12.7862105632227374`, 
        y3 \[Rule] 5.3846382885525772`, y4 \[Rule] 1.3425354944354173`}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\n
      \t{a0 + a1 + a2 + a3 == \ 15.6807911340871513`, \n\t\t
        a0 + a1/2 - a2/2 - a3 == 12.7862105632227374`, \n\t\t
        a0 - a1/2 - a2/2 + a3 == 5.3846382885525772`, \n\t\t
        a0 - a1 + a2 - a3 == \ 1.3425354944354173`}, {a0, a1, a2, a3}]\)], 
  "Input"],

Cell[BoxData[
    \({{a0 \[Rule] 8.89417072201219838`, a1 \[Rule] 7.24660930477396458`, 
        a2 \[Rule] \(-0.382507407750914829`\), 
        a3 \[Rule] \(-0.0774814849480976519`\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"Macintosh 3.0",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{28, Automatic}, {30, Automatic}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 1776, 30, 619, "Input"],
Cell[3510, 83, 148, 2, 26, "Output"]
}, Open  ]],
Cell[3673, 88, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[3768, 93, 823, 15, 155, "Input"],
Cell[4594, 110, 149, 2, 26, "Output"]
}, Open  ]],
Cell[4758, 115, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[4853, 120, 823, 15, 155, "Input"],
Cell[5679, 137, 149, 2, 26, "Output"]
}, Open  ]],
Cell[5843, 142, 70, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[5938, 147, 835, 15, 155, "Input"],
Cell[6776, 164, 148, 2, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6961, 171, 681, 10, 267, "Input"],
Cell[7645, 183, 178, 3, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7860, 191, 299, 6, 107, "Input"],
Cell[8162, 199, 199, 3, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

